//
//  BPBICloudMigrator.h
//  BISubstrate
//
//  Created by Alykhan Jetha on 12-12-07.
//
//

#import <Cocoa/Cocoa.h>

@class MCSQLiteConnection;
@class MCPModel, MCPEntity;
@class BIDatabaseObjectContext;


@interface BPBICloudMigrator : NSObject {
    NSString    *billingsAppSupportFolder;
    MCPModel    *billingsModel;
    MCSQLiteConnection  *billingsConnection;
    
    BIDatabaseObjectContext *objectContext;
    
    NSMutableDictionary *entityRowCounts;
	NSMutableArray *invoicesPendingConversion;
    
    NSUInteger totalCount;
    
    NSMutableArray *errors;
    
    id delegate;

}

@property (nonatomic,retain) NSString* billingsAppSupportFolder;
@property (nonatomic,retain) MCPModel* billingsModel;
@property (nonatomic,retain) MCSQLiteConnection* billingsConnection;
@property (nonatomic,assign) BIDatabaseObjectContext *objectContext;
@property (nonatomic,assign) id delegate;
@property (nonatomic,retain) NSMutableArray* invoicesPendingConversion;

- (id)initWithBillingsSupportFolder:(NSString*)appSupportFolder objectContext:(BIDatabaseObjectContext *)oc delegate:(id)aDelegate;

- (BOOL)isSchemaValidForMigration;

- (NSUInteger)fetchObjectCounts;

- (void)migrate;

- (void)convertHTMLInvoices:(NSArray *)invoices;

- (BOOL)moveBillingsAside;
- (BOOL)moveBillingsProAside;

@end

@protocol BPBICloudMigratorDelegate
- (void)totalEntityRowsToMigrate:(unsigned long long)totalRows;
- (void)incrementEntityProgress;
- (void)changeToIndeterminateProgress;
- (void)migrationComplete:(BPBICloudMigrator *)migrator;
- (void)migrationComplete:(BPBICloudMigrator *)migrator withErrors:(NSArray *)errors;
@end


